#pragma once
#include "main.h"
#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif


#define ADC1_NUM_CH   8
#define ADC2_NUM_CH   8
#define ADC3_NUM_CH   3



// ===== ADC1 (Rank1~8: IN8,9,10,11,12,13,14,15) =====
typedef enum {
  ADC1_TANK_FLOW_ADC = 0,   // IN8  (PB0)
  ADC1_TDS_ADC,             // IN9  (PB1)
  ADC1_H_GAS_SOL1_CUR,      // IN10 (PC0)
  ADC1_E_RORATE_PUMP_CUR,   // IN11 (PC1)
  ADC1_DC_FAN_CUR,          // IN12 (PC2)
  ADC1_EXT_H_O_ADC,         // IN13 (PC3)
  ADC1_E_LEAK_ADC,          // IN14 (PC4)
  ADC1_TANK_O_LEAK_ADC      // IN15 (PC5)
} ADC1_Map;

// ===== ADC2 (Rank1~8: IN0,1,2,3,4,5,6,7) =====
typedef enum {
  ADC2_EXT_O_H_ADC = 0,     // IN0 (PA0)
  ADC2_EXT_DEW2_ADC,        // IN1 (PA1)
  ADC2_EXT_DEW1_ADC,        // IN2 (PA2)
  ADC2_TANK_ADD_PUMP_CUR,   // IN3 (PA3)
  ADC2_EXT_FLOW2_ADC,       // IN4 (PA4)
  ADC2_EXT_FLOW1_ADC,       // IN5 (PA5)
  ADC2_SPARE_4_20_ADC_1,    // IN6 (PA6)
  ADC2_SPARE_4_20_ADC_2     // IN7 (PA7)
} ADC2_Map;

// ===== ADC3 (Rank1~8: IN4,5,6,7,8,9,14,15) =====
typedef enum {
  ADC3_H_GAS_SOL2_CUR=0,           // IN8  (PF10)
  ADC3_CARTRIDGE_HEATER_CUR,            // IN9  (PF3)
  ADC3_H_GAS_SOL3_CUR,              // IN14 (PF4)
  ADC3_CURRENT_ADC               // IN15 (PF5)
} ADC3_Map;

void ADC_APP_Start(void);        // 세 ADC 모두 DMA 시작
void ADC_APP_Poll(void);         // 새 데이터 플래그 처리(선택)

const uint16_t* ADC1_Data(void);
const uint16_t* ADC2_Data(void);
const uint16_t* ADC3_Data(void);
int  ADC1_Len(void);
int  ADC2_Len(void);
int  ADC3_Len(void);

extern volatile uint8_t g_adc1_new, g_adc2_new, g_adc3_new;
extern uint16_t s_adc1_shadow[ADC1_NUM_CH];
extern uint16_t s_adc2_shadow[ADC2_NUM_CH];
extern uint16_t s_adc3_shadow[ADC3_NUM_CH];

#ifdef __cplusplus
}
#endif
