/*
 * telemetry.h
 *
 *  Created on: Nov 28, 2025
 *      Author: c6h6
 */

#ifndef INC_TELEMETRY_H_
#define INC_TELEMETRY_H_

#include <stdint.h>
#include "gpio.h"

#define DIN_TANK1()   Read_DIN(GPIOH, GPIO_PIN_11)   // E_TANK_D_SEN_IN4
#define DIN_TANK2()   Read_DIN(GPIOH, GPIO_PIN_10)   // E_TANK_D_SEN_IN3
#define DIN_TANK3()   Read_DIN(GPIOH, GPIO_PIN_9)   // E_TANK_D_SEN_IN2
#define DIN_TANK4()   Read_DIN(GPIOH, GPIO_PIN_8)   // E_TANK_D_SEN_IN1
#define DIN_CONTACTCTL() Read_DIN(GPIOF, GPIO_PIN_2) // ELEC_CONTACT_CTL
#define DIN_CONTACT() Read_DIN(GPIOF, GPIO_PIN_1)    // ELEC_CONTACT_CHECK
#define DIN_SWITCH()  Read_DIN(GPIOG, GPIO_PIN_5)    // SWITCH
#define DIN_DAC_RDY() Read_DIN(GPIOH, GPIO_PIN_10)   // DAC_RDY
#define DIN_RTD_DRDY0() Read_DIN(GPIOE, GPIO_PIN_15) // �븘�슂�떆 �궗�슜: RTD_DRDY0
#define DIN_H_GAS_SOL1_OUT() Read_DIN(GPIOH, GPIO_PIN_5) // H_GAS_SOL1_OUT
#define DIN_H_GAS_SOL2_OUT() Read_DIN(GPIOH, GPIO_PIN_4) // H_GAS_SOL2_OUT
#define DIN_H_GAS_SOL3_OUT() Read_DIN(GPIOH, GPIO_PIN_3) // H_GAS_SOL3_OUT
#define DIN_PSUENCTL() Read_DIN(GPIOF, GPIO_PIN_0) // ELEC_PSU_EN_CTL
#define DIN_CARTRIDGE_HEATER() Read_DIN(GPIOH, GPIO_PIN_2) // CARTRIDGE_HEATER

extern float g_t1;
extern float g_t2;
extern float g_t3;
extern volatile float PWM_FAN_RPM;
extern volatile float TANK_ADD_PUMP_FREQ;


void ESP32_Telemetry_Task_1Hz(void);

static inline uint16_t Read_DIN(GPIO_TypeDef *port, uint16_t pin)
{
    return (HAL_GPIO_ReadPin(port, pin) == GPIO_PIN_SET) ? 1 : 0;
}

#endif /* INC_TELEMETRY_H_ */
