/*
 * dummy_telemetry.h
 *
 *  Created on: 2025. 11. 15.
 *      Author: c6h6
 */

#ifndef MAIN_DUMMY_TELEMETRY_H_
#define MAIN_DUMMY_TELEMETRY_H_

#pragma once

#define HXB2_DUMMY_FRAME_COUNT 25
#include <stdint.h>
#include <stdbool.h>
typedef struct {
    uint16_t cmd_rev;
    bool     cmd_rev_initialized;

    bool psu48_ena;
    bool electrolyte_ctrl_ena;
    bool highp_production_ena;

    float psu48_v_set;
    float psu48_i_set;
    float electrolyte_t_sp_degC;
    float electrolyte_flow_sp_slm;
} hxb_desired_shadow_t;


static const char *hxb2_dummy_frames[HXB2_DUMMY_FRAME_COUNT] = {
    "{\"schema\": \"hxb2k-icd:2.0\","
"\"device_id\": \" HXB-2KW-V1.0-0001\","
"\"ts\": \"2025-10-18T16:00:00Z\","
"\"seq_tlm\": 28801,"
"\"applied_rev\": 3,"
"\"telemetry\": {"
"\"AI\": {"
"\"TANK_T_DEGC\": 50.6,"
"\"BEFORE_STACK_T_DEGC\": 47.0,"
"\"AFTER_STACK_T_DEGC\": 52.1,"
"\"TOTAL_DISSOLVED_PPM\": 277,"
"\"MEASURED_CURRENT_A\": 50.1,"
"\"STACK_VOLTAGE_V\": 40.7,"
"\"H2_LEAK_PPM\": 182,"
"\"ELECTROLYTE_LEAK_SW_A\": 0,"
"\"O2_FLOW_SLM\": 4.38,"
"\"H2_FLOW_SLM\": 8.75,"
"\"ELEC_FLOW_SLM\": 1519,"
"\"H2_PRESS1_BAR\": 0,"
"\"H2_PRESS2_BAR\": 0,"
"\"H2_IN_O2_VOLPCT\": 0.82,"
"\"O2_IN_H2_PPM\": 191,"
"\"DEWPOINT1_DEGC\": -46.8,"
"\"DEWPOINT2_DEGC\": -46.2,"
"\"PWMFAN_DUTY_PCT\": 60,"
"\"PWMFAN_PULSE_HZ\": 125,"
"\"AXIALFAN_STAT_A\": 0.05,"
"\"MAKEUP_PUMP_CONTROL_V\": 0,"
"\"MAKEUP_PUMP_STAT_A\": 0,"
"\"CIRC_PUMP_CONTROL_V\": 3,"
"\"CIRC_PUMP_STAT_A\": 1.7,"
"\"HEATER_STAT_A\": 6.21,"
"\"H2SOLVALVE_1_STAT_A\": 0.75,"
"\"H2SOLVALVE_2_STAT_A\": 0,"
"\"H2SOLVALVE_3_STAT_A\": 0,"
"\"PSU48_VOLTAGE_SV_V\" : 48,"
"\"PSU48_CURRENT_SV_A\" : 15,"
"\"ELECTROLYTE_TEMP_SV_DEGC\" : 50,"
"\"ELECTROLYTE_FLOW_SV_SLM\" : 2"

"},"
"\"DI\": {"
"\"TANK_PRESS_SW\": true,"
"\"LEVEL_SINGLE\": true,"
"\"LEVEL_DOUBLE_HIGHER\": true,"
"\"LEVEL_DOUBLE_LOWER\": false,"
"\"HEATER_CTRL\": true,"
"\"HEATER_STAT\": true,"
"\"H2SOLVALVE_1_CTRL\": true,"
"\"H2SOLVALVE_2_CTRL\": false,"
"\"H2SOLVALVE_3_CTRL\": false,"
"\"PSU48_MC_CTRL\": true,"
"\"PSU48_MC_STAT\": true,"
"\"PSU48_PWR_ENA_CTRL\": true,"
"\"PSU48_MODE_CV_CTRL\": false,"
"\"PSU48_MODE_CC_CTRL\": true,"
"\"ELECTROLYTE_CTRL_CTRL\": true,"
"\"HIGHP_PRODUCTION_CTRL\": false,"
"\"EMERGENCY_ACTIVE\": false}}}", 
/////////////////////////////////////////////////////////////
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T9:00:00Z\",\"seq_tlm\":3601,\"applied_rev\" \
    "":1,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":25.3,\"BEFORE_STACK_T_DEGC\":25.1,\"AFTER_STACK_T_DEGC\":25.6,\"TOTAL_DISSOLV" \
    "ED_PPM\":287,\"MEASURED_CURRENT_A\":0,\"STACK_VOLTAGE_V\":0,\"H2_LEAK_PPM\":173,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FLOW_SL" \
    "M\":0,\"H2_FLOW_SLM\":0,\"ELEC_FLOW_SLM\":0,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0,\"O2_IN_H2_PPM" \
    "\":0,\"DEWPOINT1_DEGC\":-48.5,\"DEWPOINT2_DEGC\":-49.2,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":126,\"AXIALFAN_STAT_A\" \
    "":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":0,\"CIRC_PUMP_STAT_A\":0,\"HEATER_ST" \
    "AT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true,\"LEVEL_SINGLE\":true,\"" \
    "LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":true,\"HEATER_CTRL\":false,\"H2SOLVALVE_1_CTRL\":false,\"H2SOLVALVE_2_" \
    "CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":false,\"PSU48_MC_STAT\":false,\"PSU48_PWR_ENA_CTRL\":false,\"" \
    "PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":false,\"ELECTROLYTE_CTRL_CTRL\":false,\"HIGHP_PRODUCTION_CTRL\":false," \
    "\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T10:00:00Z\",\"seq_tlm\":7201,\"applied_rev" \
    "\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":45.6,\"BEFORE_STACK_T_DEGC\":42.4,\"AFTER_STACK_T_DEGC\":47.6,\"TOTAL_DISSOL" \
    "VED_PPM\":259,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":40.1,\"H2_LEAK_PPM\":192,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FL" \
    "OW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1516,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0." \
    "76,\"O2_IN_H2_PPM\":205,\"DEWPOINT1_DEGC\":-46.5,\"DEWPOINT2_DEGC\":-49.9,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":123" \
    ",\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_STA" \
    "T_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true," \
    "\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL" \
    "\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PW" \
    "R_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUC" \
    "TION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T11:00:00Z\",\"seq_tlm\":10801,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.1,\"BEFORE_STACK_T_DEGC\":47.4,\"AFTER_STACK_T_DEGC\":52.4,\"TOTAL_DISSO" \
    "LVED_PPM\":294,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":40.2,\"H2_LEAK_PPM\":158,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1492,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.77,\"O2_IN_H2_PPM\":207,\"DEWPOINT1_DEGC\":-45,\"DEWPOINT2_DEGC\":-48.7,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "0,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T12:00:00Z\",\"seq_tlm\":14401,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.5,\"BEFORE_STACK_T_DEGC\":47.9,\"AFTER_STACK_T_DEGC\":52.9,\"TOTAL_DISSO" \
    "LVED_PPM\":273,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":40.3,\"H2_LEAK_PPM\":187,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.38,\"H2_FLOW_SLM\":8.76,\"ELEC_FLOW_SLM\":1504,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".79,\"O2_IN_H2_PPM\":191,\"DEWPOINT1_DEGC\":-45.9,\"DEWPOINT2_DEGC\":-49.5,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "7,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_ST" \
    "AT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true" \
    ",\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTR" \
    "L\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_P" \
    "WR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODU" \
    "CTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T13:00:00Z\",\"seq_tlm\":18001,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.6,\"BEFORE_STACK_T_DEGC\":47.2,\"AFTER_STACK_T_DEGC\":52.5,\"TOTAL_DISSO" \
    "LVED_PPM\":251,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":40.4,\"H2_LEAK_PPM\":165,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1511,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".81,\"O2_IN_H2_PPM\":204,\"DEWPOINT1_DEGC\":-47.5,\"DEWPOINT2_DEGC\":-49.7,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "9,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T14:00:00Z\",\"seq_tlm\":21601,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.9,\"BEFORE_STACK_T_DEGC\":47.8,\"AFTER_STACK_T_DEGC\":52.2,\"TOTAL_DISSO" \
    "LVED_PPM\":299,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":40.5,\"H2_LEAK_PPM\":199,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1498,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.78,\"O2_IN_H2_PPM\":210,\"DEWPOINT1_DEGC\":-46.7,\"DEWPOINT2_DEGC\":-45.9,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":" \
    "121,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T15:00:00Z\",\"seq_tlm\":25201,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50,\"BEFORE_STACK_T_DEGC\":47.6,\"AFTER_STACK_T_DEGC\":52.7,\"TOTAL_DISSOLV" \
    "ED_PPM\":268,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":40.6,\"H2_LEAK_PPM\":154,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FLO" \
    "W_SLM\":4.37,\"H2_FLOW_SLM\":8.73,\"ELEC_FLOW_SLM\":1507,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0.8" \
    ",\"O2_IN_H2_PPM\":191,\"DEWPOINT1_DEGC\":-45.7,\"DEWPOINT2_DEGC\":-45.2,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":124,\" \
    ""AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_STA" \
    "T_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true," \
    "\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL" \
    "\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PW" \
    "R_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUC" \
    "TION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T16:00:00Z\",\"seq_tlm\":28801,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.6,\"BEFORE_STACK_T_DEGC\":47,\"AFTER_STACK_T_DEGC\":52.1,\"TOTAL_DISSOLV" \
    "ED_PPM\":277,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":40.7,\"H2_LEAK_PPM\":182,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1519,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".82,\"O2_IN_H2_PPM\":191,\"DEWPOINT1_DEGC\":-46.8,\"DEWPOINT2_DEGC\":-46.2,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "5,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_ST" \
    "AT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true" \
    ",\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTR" \
    "L\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_P" \
    "WR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODU" \
    "CTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T17:00:00Z\",\"seq_tlm\":32401,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.3,\"BEFORE_STACK_T_DEGC\":47.7,\"AFTER_STACK_T_DEGC\":52.8,\"TOTAL_DISSO" \
    "LVED_PPM\":290,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":40.8,\"H2_LEAK_PPM\":176,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1483,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".77,\"O2_IN_H2_PPM\":202,\"DEWPOINT1_DEGC\":-46,\"DEWPOINT2_DEGC\":-45.9,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":128," \
    "\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_ST" \
    "AT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true" \
    ",\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":false,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CT" \
    "RL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_" \
    "PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PROD" \
    "UCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T18:00:00Z\",\"seq_tlm\":36001,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":51,\"BEFORE_STACK_T_DEGC\":47.4,\"AFTER_STACK_T_DEGC\":52.4,\"TOTAL_DISSOLV" \
    "ED_PPM\":263,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":40.9,\"H2_LEAK_PPM\":195,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.38,\"H2_FLOW_SLM\":8.76,\"ELEC_FLOW_SLM\":1502,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".79,\"O2_IN_H2_PPM\":185,\"DEWPOINT1_DEGC\":-48.4,\"DEWPOINT2_DEGC\":-49.7,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "2,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T19:00:00Z\",\"seq_tlm\":39601,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.7,\"BEFORE_STACK_T_DEGC\":47.7,\"AFTER_STACK_T_DEGC\":52.7,\"TOTAL_DISSO" \
    "LVED_PPM\":281,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":41,\"H2_LEAK_PPM\":161,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FLO" \
    "W_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1490,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0.8" \
    "1,\"O2_IN_H2_PPM\":182,\"DEWPOINT1_DEGC\":-45.5,\"DEWPOINT2_DEGC\":-48.1,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":130," \
    "\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_ST" \
    "AT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true" \
    ",\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTR" \
    "L\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_P" \
    "WR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODU" \
    "CTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T20:00:00Z\",\"seq_tlm\":43201,\"applied_re" \
    "v\":3,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.4,\"BEFORE_STACK_T_DEGC\":47.3,\"AFTER_STACK_T_DEGC\":52.3,\"TOTAL_DISSO" \
    "LVED_PPM\":256,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":41.1,\"H2_LEAK_PPM\":189,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1513,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.78,\"O2_IN_H2_PPM\":200,\"DEWPOINT1_DEGC\":-47.1,\"DEWPOINT2_DEGC\":-49.4,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":" \
    "124,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUM" \
    "P_STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":" \
    "true,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1" \
    "_CTRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU" \
    "48_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_P" \
    "RODUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T21:00:00Z\",\"seq_tlm\":46801,\"applied_re" \
    "v\":4,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.2,\"BEFORE_STACK_T_DEGC\":47.1,\"AFTER_STACK_T_DEGC\":52.1,\"TOTAL_DISSO" \
    "LVED_PPM\":295,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":41.2,\"H2_LEAK_PPM\":178,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.37,\"H2_FLOW_SLM\":8.73,\"ELEC_FLOW_SLM\":1506,\"H2_PRESS1_BAR\":10,\"H2_PRESS2_BAR\":9,\"H2_IN_O2_VOLPCT\":" \
    "1.1,\"O2_IN_H2_PPM\":185,\"DEWPOINT1_DEGC\":-48.5,\"DEWPOINT2_DEGC\":-45.4,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "7,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true," \
    "\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL" \
    "\":false,\"H2SOLVALVE_2_CTRL\":true,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PW" \
    "R_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUC" \
    "TION_CTRL\":true,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-18T22:00:00Z\",\"seq_tlm\":50401,\"applied_re" \
    "v\":4,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.6,\"BEFORE_STACK_T_DEGC\":47.9,\"AFTER_STACK_T_DEGC\":53,\"TOTAL_DISSOLV" \
    "ED_PPM\":250,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":41.25,\"H2_LEAK_PPM\":150,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FL" \
    "OW_SLM\":4.38,\"H2_FLOW_SLM\":8.76,\"ELEC_FLOW_SLM\":1495,\"H2_PRESS1_BAR\":10,\"H2_PRESS2_BAR\":9,\"H2_IN_O2_VOLPCT\":1" \
    ".12,\"O2_IN_H2_PPM\":183,\"DEWPOINT1_DEGC\":-48,\"DEWPOINT2_DEGC\":-46.6,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":120," \
    "\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_STAT" \
    "_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true,\"LE" \
    "VEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL\":f" \
    "alse,\"H2SOLVALVE_2_CTRL\":true,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PWR_EN" \
    "A_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUCTION" \
    "_CTRL\":true,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\" 2025-10-18T23:00:00Z\",\"seq_tlm\":54001,\"applied_r" \
    "ev\":4,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.3,\"BEFORE_STACK_T_DEGC\":47.5,\"AFTER_STACK_T_DEGC\":52.6,\"TOTAL_DISS" \
    "OLVED_PPM\":284,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":41.58,\"H2_LEAK_PPM\":196,\"ELECTROLYTE_LEAK_SW_A\":0,\"" \
    "O2_FLOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1520,\"H2_PRESS1_BAR\":10,\"H2_PRESS2_BAR\":9,\"H2_IN_O2_VOLPC" \
    "T\":1.06,\"O2_IN_H2_PPM\":186,\"DEWPOINT1_DEGC\":-49.9,\"DEWPOINT2_DEGC\":-48.4,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ" \
    "\":129,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_" \
    "PUMP_STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":" \
    "true,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1" \
    "_CTRL\":false,\"H2SOLVALVE_2_CTRL\":true,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU" \
    "48_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_P" \
    "RODUCTION_CTRL\":true,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T00:00:00Z\",\"seq_tlm\":57601,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.9,\"BEFORE_STACK_T_DEGC\":47.6,\"AFTER_STACK_T_DEGC\":52.8,\"TOTAL_DISSO" \
    "LVED_PPM\":272,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":42.1,\"H2_LEAK_PPM\":163,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1488,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".78,\"O2_IN_H2_PPM\":199,\"DEWPOINT1_DEGC\":-47.2,\"DEWPOINT2_DEGC\":-49.9,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "5,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T01:00:00Z\",\"seq_tlm\":61201,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.7,\"BEFORE_STACK_T_DEGC\":47.3,\"AFTER_STACK_T_DEGC\":52.3,\"TOTAL_DISSO" \
    "LVED_PPM\":298,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":42.3,\"H2_LEAK_PPM\":184,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.37,\"H2_FLOW_SLM\":8.73,\"ELEC_FLOW_SLM\":1500,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.8,\"O2_IN_H2_PPM\":186,\"DEWPOINT1_DEGC\":-49.4,\"DEWPOINT2_DEGC\":-47.1,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":1" \
    "26,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_S" \
    "TAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tru" \
    "e,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CT" \
    "RL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_" \
    "PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PROD" \
    "UCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T02:00:00Z\",\"seq_tlm\":64801,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.8,\"BEFORE_STACK_T_DEGC\":48,\"AFTER_STACK_T_DEGC\":52.2,\"TOTAL_DISSOLV" \
    "ED_PPM\":260,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":42.3,\"H2_LEAK_PPM\":157,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_FLO" \
    "W_SLM\":4.38,\"H2_FLOW_SLM\":8.76,\"ELEC_FLOW_SLM\":1518,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0.8" \
    "1,\"O2_IN_H2_PPM\":200,\"DEWPOINT1_DEGC\":-50,\"DEWPOINT2_DEGC\":-49.3,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":128,\"" \
    "AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_STAT" \
    "_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true,\" \
    ""LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL\" \
    "":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PWR" \
    "_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUCT" \
    "ION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T03:00:00Z\",\"seq_tlm\":68401,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.4,\"BEFORE_STACK_T_DEGC\":47.1,\"AFTER_STACK_T_DEGC\":52.9,\"TOTAL_DISSO" \
    "LVED_PPM\":279,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":42.3,\"H2_LEAK_PPM\":193,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1493,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".79,\"O2_IN_H2_PPM\":197,\"DEWPOINT1_DEGC\":-49.9,\"DEWPOINT2_DEGC\":-48.4,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "1,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T04:00:00Z\",\"seq_tlm\":72001,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.1,\"BEFORE_STACK_T_DEGC\":47.5,\"AFTER_STACK_T_DEGC\":52.5,\"TOTAL_DISSO" \
    "LVED_PPM\":266,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":42.4,\"H2_LEAK_PPM\":169,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.38,\"H2_FLOW_SLM\":8.75,\"ELEC_FLOW_SLM\":1509,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.82,\"O2_IN_H2_PPM\":201,\"DEWPOINT1_DEGC\":-47.3,\"DEWPOINT2_DEGC\":-48.6,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":" \
    "123,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T05:00:00Z\",\"seq_tlm\":75601,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.9,\"BEFORE_STACK_T_DEGC\":47.6,\"AFTER_STACK_T_DEGC\":52.1,\"TOTAL_DISSO" \
    "LVED_PPM\":291,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":42.4,\"H2_LEAK_PPM\":185,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2_F" \
    "LOW_SLM\":4.37,\"H2_FLOW_SLM\":8.73,\"ELEC_FLOW_SLM\":1485,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0" \
    ".77,\"O2_IN_H2_PPM\":203,\"DEWPOINT1_DEGC\":-47.7,\"DEWPOINT2_DEGC\":-49.3,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":12" \
    "7,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_PUMP_" \
    "STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":tr" \
    "ue,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_C" \
    "TRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48" \
    "_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRO" \
    "DUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T06:00:00Z\",\"seq_tlm\":79201,\"applied_re" \
    "v\":5,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.8,\"BEFORE_STACK_T_DEGC\":47.8,\"AFTER_STACK_T_DEGC\":52.6,\"TOTAL_DISSO" \
    "LVED_PPM\":275,\"MEASURED_CURRENT_A\":50.1,\"STACK_VOLTAGE_V\":42.4,\"H2_LEAK_PPM\":172,\"ELECTROLYTE_LEAK_SW_A\":0,\"O2" \
    "_FLOW_SLM\":4.38,\"H2_FLOW_SLM\":8.76,\"ELEC_FLOW_SLM\":1515,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\"" \
    ":0.8,\"O2_IN_H2_PPM\":208,\"DEWPOINT1_DEGC\":-49,\"DEWPOINT2_DEGC\":-45.6,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\":122" \
    ",\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3,\"CIRC_PUMP_STA" \
    "T_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0},\"DI\":{\"TANK_PRESS_SW\":true," \
    "\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVALVE_1_CTRL" \
    "\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true,\"PSU48_PW" \
    "R_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HIGHP_PRODUC" \
    "TION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T07:00:00Z\",\"seq_tlm\":82801,\"applied_re" \
    "v\":6,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":50.1,\"BEFORE_STACK_T_DEGC\":47.2,\"AFTER_STACK_T_DEGC\":52.5,\"TOTAL_DISSO" \
    "LVED_PPM\":279,\"MEASURED_CURRENT_A\":50,\"STACK_VOLTAGE_V\":42.4,\"H2_LEAK_PPM\":1547,\"ELECTROLYTE_LEAK_SW_A\":0.01,\"" \
    "O2_FLOW_SLM\":4.37,\"H2_FLOW_SLM\":8.74,\"ELEC_FLOW_SLM\":1497,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT" \
    "\":0.78,\"O2_IN_H2_PPM\":194,\"DEWPOINT1_DEGC\":-47.3,\"DEWPOINT2_DEGC\":-45.7,\"PWMFAN_DUTY_PCT\":60,\"PWMFAN_PULSE_HZ\" \
    "":130,\"AXIALFAN_STAT_A\":0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":3.1,\"CIRC_P" \
    "UMP_STAT_A\":1.7,\"HEATER_STAT_A\":6.21,\"H2SOLVALVE_1_STAT_A\":0.75,\"H2SOLVALVE_2_STAT_A\":0.75},\"DI\":{\"TANK_PRESS_" \
    "SW\":true,\"LEVEL_SINGLE\":true,\"LEVEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":true,\"H2SOLVA" \
    "LVE_1_CTRL\":true,\"H2SOLVALVE_2_CTRL\":false,\"H2SOLVALVE_3_CTRL\":false,\"PSU48_MC_CTRL\":true,\"PSU48_MC_STAT\":true," \
    "\"PSU48_PWR_ENA_CTRL\":true,\"PSU48_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":true,\"ELECTROLYTE_CTRL_CTRL\":true,\"HI" \
    "GHP_PRODUCTION_CTRL\":false,\"EMERGENCY_ACTIVE\":false}}}",
    "{\"schema\":\"hxb2k-icd:2.0\",\"device_id\":\"HXB2k-001\",\"ts\":\"2025-10-19T08:00:00Z\",\"seq_tlm\":86401,\"applied_re" \
    "v\":6,\"telemetry\":{\"AI\":{\"TANK_T_DEGC\":35.6,\"BEFORE_STACK_T_DEGC\":28.1,\"AFTER_STACK_T_DEGC\":29.6,\"TOTAL_DISSO" \
    "LVED_PPM\":291,\"MEASURED_CURRENT_A\":0,\"STACK_VOLTAGE_V\":0,\"H2_LEAK_PPM\":157,\"ELECTROLYTE_LEAK_SW_A\":0.01,\"O2_FL" \
    "OW_SLM\":0,\"H2_FLOW_SLM\":0,\"ELEC_FLOW_SLM\":0,\"H2_PRESS1_BAR\":0,\"H2_PRESS2_BAR\":0,\"H2_IN_O2_VOLPCT\":0,\"O2_IN_H" \
    "2_PPM\":0,\"DEWPOINT1_DEGC\":-32,\"DEWPOINT2_DEGC\":-31,\"PWMFAN_DUTY_PCT\":0,\"PWMFAN_PULSE_HZ\":0,\"AXIALFAN_STAT_A\":" \
    "0.05,\"MAKEUP_PUMP_CONTROL_V\":0,\"MAKEUP_PUMP_STAT_A\":0,\"CIRC_PUMP_CONTROL_V\":0,\"CIRC_PUMP_STAT_A\":0,\"HEATER_STAT" \
    "_A\":0,\"H2SOLVALVE_1_STAT_A\":0,\"H2SOLVALVE_2_STAT_A\":0.75},\"DI\":{\"TANK_PRESS_SW\":true,\"LEVEL_SINGLE\":true,\"LE" \
    "VEL_DOUBLE_HIGHER\":true,\"LEVEL_DOUBLE_LOWER\":false,\"HEATER_CTRL\":false,\"H2SOLVALVE_1_CTRL\":true,\"H2SOLVALVE_2_CT" \
    "RL\":true,\"H2SOLVALVE_3_CTRL\":true,\"PSU48_MC_CTRL\":false,\"PSU48_MC_STAT\":false,\"PSU48_PWR_ENA_CTRL\":false,\"PSU4" \
    "8_MODE_CV_CTRL\":false,\"PSU48_MODE_CC_CTRL\":false,\"ELECTROLYTE_CTRL_CTRL\":false,\"HIGHP_PRODUCTION_CTRL\":false,\"EM" \
    "ERGENCY_ACTIVE\":true}}}"
};

#endif /* MAIN_DUMMY_TELEMETRY_H_ */
